/****
 * CTextDocument.h
 *
 *	Document class for a tiny editor.
 *

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.

 ****/

#define	_H_CTextDocument			/* Include this file only once */
#include <CDocument.h>
#include <CApplication.h>

CLASS CTextPane;
CLASS CResFile;
CLASS CScrollPane;

#define	WINDculture		500		/* Resource ID for WIND template */


struct CTextDocument : CDocument {

	CTextPane	*fTextEdit;
	Boolean		 fReadOnly;			// Is this document read only?

	short		 fFont;
	short		 fSize;
	Boolean		 fHaveWindSize;
	Rect		 fWindSizeLoc;

						/** Construction/Destruction **/
  	virtual	void        ITextDocument(CApplication *aSupervisor);
	virtual	void		Notify(CTask *theTask);

						/** General Query **/
	virtual	void		GetSelectionStr(Str255 sel);
	virtual	long		GetNumLines(void);
	virtual	Boolean		IsItReadOnly(void);

						/** File Name/Path Query **/
	virtual	void		GetFileName(Str255 fileName);
	virtual	void		GetFilePath(Str255 filePath);
	virtual	void		GetFSSpec(FSSpec *spec);

						/** Filing **/
	virtual	void		NewFile(void);
	virtual	void		OpenFile(SFReply *macSFReply);

	virtual	void		Clean(void);
	virtual	void		ReadRsrcFork(SFReply *macSFReply);
	virtual	void		WriteRsrcFork(void);

	virtual	Boolean		DoSave(void);
	virtual	Boolean		DoSaveAs(SFReply *macSFReply);

						/** Build Window and contents **/
	virtual	void		BuildWindow(Handle theData);
	virtual	void		MakeWindow(void);
	virtual	void		BuildWindowContents(void);
	virtual	void		MakeTextPane(CScrollPane *theScrollPane);

	virtual	Handle		GetTextHandle(void);		/* don't change it! */
	virtual	void		SelectFT(long line1, long col1, long line2, long col2);
	virtual	void		SelectLine(long line);
	virtual	void		ScrollToSelection(void);
	virtual	void		Select(void);				// bring to front

						/** Command handling **/
	virtual void		DoCommand(long theCommand);
	virtual void		UpdateMenus(void);


};
